// shut up vscode
import funkin.utils.CoolUtil;
import flixel.text.FlxText;
import flixel.text.FlxTextAlign;
import funkin.savedata.FunkinSave;

importScript("data/scripts/progressionHandler");
if (FlxG.save.data.hatenaDone && !FlxG.save.data.graspDone)
	FlxG.save.data.daweegeeCursedMenu = true;
else
	FlxG.save.data.daweegeeCursedMenu = false;

var curWacky:Array<String> = [];
var bg:FunkinSprite = new FunkinSprite().loadGraphic(Paths.image('menus/titlescreen/bg'));
var spiral:FunkinSprite = new FunkinSprite().loadGraphic(Paths.image('stages/weegee/deathspiral'));
var swirl = new CustomShader('swirl');
var weegee:FunkinSprite = new FunkinSprite(650, 430).loadGraphic(Paths.image('menus/titlescreen/smalleegee'));
var bg2:FunkinSprite = new FunkinSprite().loadGraphic(Paths.image('menus/titlescreen/bggrass'));

var ytlogo:FunkinSprite = new FunkinSprite();
ytlogo.frames = Paths.getSparrowAtlas('menus/titlescreen/newgroundsytp');
ytlogo.animation.addByPrefix("intro", "play", 24, false);

var logo:FunkinSprite = new FunkinSprite(0, -50);
if (!FlxG.save.data.daweegeeCursedMenu) {
	logo.frames = Paths.getSparrowAtlas('menus/titlescreen/logo');
	logo.animation.addByPrefix("bumpin", "logo bumpin", 24, false);
} else {
	logo.loadGraphic(Paths.image('menus/titlescreen/logoCursed'));
	logo.x = 62;
	logo.y = 68;
}

var transitioning:Bool = false;
var title:FunkinSprite = new FunkinSprite(30, 620);

var camMain:FlxCamera = new FlxCamera(0, 0, 960, 720);
camMain.bgColor = 0;
var camFront:FlxCamera = new FlxCamera(0, 0, 960, 720);
camFront.bgColor = 0;

// skipTransition = true;

var epicText:FunkinText;
var finished:Bool = false;

function create() {
	FlxG.cameras.add(camMain, false);
	FlxG.cameras.add(camFront, false);
	FlxG.mouse.useSystemCursor = false;
	FlxG.mouse.load(Assets.getBitmapData(Paths.image('game/cursor')));

	betaChance = FlxG.random.int(1, 69);
	CoolUtil.playMenuSong();
	if (FlxG.save.data.daweegeeCursedMenu) {
		CoolUtil.playMusic(Paths.music('freakyMenuGrasp'));
		FlxG.sound.music.persist = true;
	}
	if (betaChance == 1 && !FlxG.save.data.daweegeeCursedMenu) {
		CoolUtil.playMusic(Paths.music('freakyMenuBeta'));
		FlxG.sound.music.persist = true;
	}
	epicText = new FunkinText(200, 100, 800, "Not Associated With", 36);
	epicText.setFormat(Paths.font("micross.ttf"), 62, FlxColor.WHITE);
	epicText.alignment = FlxTextAlign.CENTER;
	epicText.screenCenter(FlxAxes.X);
	epicText.antialiasing = true;

	ytlogo.screenCenter();
	ytlogo.scale.set(0.9, 0.9);
	ytlogo.antialiasing = true;

	title.frames = Paths.getSparrowAtlas('menus/titlescreen/pressenter');
	title.animation.addByPrefix("idle", "Press Enter to DIE! instance ", 24, true);
	title.animation.addByPrefix("idleEnter", "Press Enter to DIE! Selected instance ", 24, true);
	title.animation.addByPrefix("enter", "Press Enter to DIE! Transition instance ", 24, false);

	var epicLines:Array<String> = CoolUtil.coolTextFile(Paths.txt('introText'));
	if (epicLines.contains(''))
		epicLines.remove('');
	curWacky = epicLines[FlxG.random.int(0, epicLines.length)];
	trace(curWacky);
	if (curWacky == null) {
		curWacky = epicLines[0];
		trace("was Null." + curWacky);
	}

	bg.visible = false;
	bg.scale.set(1.05, 1.05);
	bg.antialiasing = true;

	spiral.scale.set(1.5, 1.5);
	spiral.scrollFactor.set(0, 0);
	spiral.screenCenter();
	spiral.antialiasing = true;
	spiral.visible = false;

	swirl.speen = 0;
	camMain.addShader(swirl);

	bg2.visible = false;
	bg2.scale.set(1.05, 1.05);
	bg2.antialiasing = true;

	logo.visible = false;
	logo.antialiasing = true;

	title.visible = false;
	title.antialiasing = true;

	epicText.alpha = 0.001;
	ytlogo.alpha = 0.001;
	title.scale.set(0.5, 0.5);
	title.updateHitbox();
	title.animation.play('idle', true);

	bg.cameras = [camMain];
	weegee.cameras = [camMain];
	bg2.cameras = [camMain];

	title.cameras = [camFront];
	logo.cameras = [camFront];
	// title.addOffset('idleEnter', -18, 4);
	// title.addOffset('enter', 40, -214);

	if (FlxG.save.data.daweegeeCursedMenu)
		weegee.loadGraphic(Paths.image('menus/titlescreen/daweeg'));
	if (betaChance == 1 && !FlxG.save.data.daweegeeCursedMenu)
		weegee.loadGraphic(Paths.image('menus/titlescreen/lebron'));
	weegee.visible = false;
	weegee.antialiasing = true;
	weegee.angle = 12;

	bg.scrollFactor.set(0.4, 0.8);
	weegee.scrollFactor.set(0.7, 0.8);

	add(bg);
	add(spiral);
	add(weegee);
	add(bg2);
	add(logo);
	add(title);
	add(ytlogo);
	add(epicText);

	if (FlxG.save.data.daweegeeCursedMenu) {
		bg.color = 0xFF103015;
		spiral.color = 0xFF476c47;
		bg2.color = 0xFF476c47;
	}

	if (curBeat > 16)
		finishIntro();

	/*FlxG.save.data.pbDone = true;
		FlxG.save.data.mm2Done = true;
		FlxG.save.data.pissDone = true; 
		FlxG.save.data.sadisticDone = true; 
		FlxG.save.data.flowaDone = true;
		FlxG.save.data.omgDone = true; 
		FlxG.save.data.smokeDone = true; 
		FlxG.save.data.nobreathDone = true; 
		FlxG.save.data.importantDone = true;
		FlxG.save.data.sexerDone = true; 
		FlxG.save.data.hatenaDone = false; 
		FlxG.save.data.graspDone = false;
		FlxG.save.data.daweegeeCursedMenu = false;
	 */
}

function finishIntro() {
	finished = true;
	trace(finished);

	camMain.zoom = 2;
	camFront.zoom = 2.2;
	camFront.flash(FlxColor.WHITE, 0.4);

	FlxTween.tween(weegee, {y: 120}, 1.7, {startDelay: 0.5});
	bg.visible = true;
	weegee.visible = true;
	bg2.visible = true;
	logo.visible = true;
	title.visible = true;
	epicText.destroy();
	ytlogo.destroy();

	FlxTween.tween(camMain, {zoom: 1}, 0.3, {ease: FlxEase.expoOut});
	FlxTween.tween(camFront, {zoom: 1}, 0.3, {ease: FlxEase.expoOut});
}

function pressedEnter() {
	trace(FlxG.save.data.hatenaDone + FlxG.save.data.graspDone + "menucursed? " + FlxG.save.data.daweegeeCursedMenu);

	// save data defaults if not already set
	if (FlxG.save.data.subtitles_toggle == null)
		FlxG.save.data.subtitles_toggle = true;
	if (FlxG.save.data.midsongvids_toggle == null)
		FlxG.save.data.midsongvids_toggle = true;
	if (FlxG.save.data.fpschanges_toggle == null)
		FlxG.save.data.fpschanges_toggle = true;
	if (FlxG.save.data.flashing_toggle == null)
		FlxG.save.data.flashing_toggle = true;
	FlxG.save.data.freeplayOptionIndex = 0;

	trace("Welcome! : )");

	transitioning = true;
	if (!FlxG.save.data.daweegeeCursedMenu) {
		FlxG.sound.play(Paths.sound('menu/confirm'));
	} else
		FlxG.sound.play(Paths.sound('menu/daweegeeTitle'));
	FlxTween.cancelTweensOf(weegee);
	weegee.y = 120;
	// title.animation.play('idleEnter', true);
	title.animation.play('enter', false);
	bg.visible = false;
	spiral.visible = true;
	title.offset.set(470, 145);
	camFront.flash(FlxColor.WHITE, 0.4);
	skipTransition = false;
	FlxTween.tween(logo, {alpha: 0.001}, 0.6, {ease: FlxEase.sineIn});
	FlxTween.num(0, 30, 2.3, {startDelay: 0.3, ease: FlxEase.quartIn}, (val:Float) -> {
		swirl.speen = val;
	});
	FlxTween.tween(camMain, {zoom: 0.001}, 0.8, {startDelay: 1.5, ease: FlxEase.sineIn});
	new FlxTimer().start(2.8, () -> {
		FlxG.switchState(new MainMenuState());
	});
}

function update(elapsed:Float) {
	spiral.angle -= 0.7;

	if (finished) {
		camMain.scroll.x = FlxMath.lerp(camMain.scroll.x, (FlxG.mouse.screenX - (FlxG.width / 2)) * 0.02, (1 / 30) * 50 * elapsed);
		camMain.scroll.y = FlxMath.lerp(camMain.scroll.y, (FlxG.mouse.screenY - 6 - (FlxG.height / 2)) * 0.01, (1 / 30) * 50 * elapsed);
	}

	if (FlxG.sound.music != null && controls.ACCEPT && !finished && !transitioning && FlxG.sound.music.playing) {
		finishIntro();
		// skip intro music if intro finishes early (enter pressed during it)
		if (FlxG.sound.music.time < 7397 && !FlxG.save.data.daweegeeCursedMenu)
		FlxG.sound.music.time = 7397;
	}
	else if (FlxG.sound.music != null && controls.ACCEPT && finished && !transitioning && FlxG.sound.music.playing)
		pressedEnter();
	else if (FlxG.sound.music != null && controls.ACCEPT && finished && transitioning && FlxG.sound.music.playing)
		FlxG.switchState(new MainMenuState());
}

function beatHit() {
	if (!FlxG.save.data.daweegeeCursedMenu)
		logo.animation.play('bumpin', true);
	if (!finished) {
		switch (curBeat) {
			case 1:
				FlxTween.tween(epicText, {alpha: 1}, 1);
				FlxTween.tween(ytlogo, {alpha: 1}, 1);
			case 3:
				ytlogo.animation.play('intro', false);
			case 6:
				FlxTween.tween(epicText, {alpha: 0.001}, 1);
				FlxTween.tween(ytlogo, {alpha: 0.001}, 1);

			case 8:
				ytlogo.visible = false;
				epicText.scale.set(0.8, 0.8);
				FlxTween.tween(epicText, {alpha: 1}, 1);
				FlxTween.tween(epicText.scale, {x: 1.2, y: 1.2}, 4);
				epicText.text = curWacky;
				epicText.screenCenter();

			case 16:
				finishIntro();
		}
	}
}
